<?php
// telegram_bot.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// 1. فایل‌های مورد نیاز
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/function.php'; // شامل توابع کمکی (botRequest, sendMessage, showMainPanel, isUserMemberOfChannel, getBotId)

// تنظیمات عمومی
$channel_username = "@shahrekordtimes";
$registration_reward = 10; // سکه برای تکمیل ثبت نام توسط کاربر جدید
$add_member_reward = 5;    // سکه برای هر عضو جدیدی که اضافه می‌شود
$referral_completion_reward = 10; // سکه برای معرف در صورت تکمیل ثبت نام زیرمجموعه (از لینک دعوت)

// دریافت آپدیت
$update = json_decode(file_get_contents("php://input"), true);
if (!$update) exit;

// متغیرهای ورودی
$chat_id = 0;
$from_id = 0;
$text = '';
$contact = null;
$file_id = null;
$callback_id = null;
$callback_data = null;
$is_callback = false;
$message = null;
$callback = null;
$new_members = [];


if (isset($_GET['admin_action'])) {
 $action = $_GET['admin_action'];
 // 1. رمزگشایی متغیرهای URL-encoded شده
 $target_chat_id = (int)$_GET['chat_id'];
 $task_title = urldecode($_GET['task_title'] ?? 'وظیفه نامعلوم'); // ✅ اصلاح: استفاده از urldecode
 $message_to_send = '';

if ($action === 'approve') {
 $reward = (int)$_GET['reward'];
 $message_to_send = "🎉 **تایید شد!**\nوظیفه شما با عنوان **{$task_title}** توسط ادمین تایید شد و **{$reward} سکه** به حساب شما واریز گردید.";

} elseif ($action === 'reject') {
 $reason = urldecode($_GET['reason'] ?? 'بدون توضیح'); // ✅ اصلاح: استفاده از urldecode
 $message_to_send = "❌ **رد شد!**\nمتاسفانه وظیفه **{$task_title}** شما توسط ادمین رد شد.\n\n**علت رد:** {$reason}";
 }

 if ($message_to_send) {
 sendMessage($target_chat_id, $message_to_send);
 }

 // مهم: پس از پردازش، از اجرای بقیه کدهای ربات جلوگیری شود.
 exit("Admin action processed.");
}
// دریافت آپدیت
$update = json_decode(file_get_contents("php://input"), true);




// 2. تشخیص نوع پیام و استخراج داده‌ها
if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $from_id = $message['from']['id'];
    $text = trim($message['text'] ?? '');
    $username = $message['from']['username'] ?? '';
    $contact = $message['contact']['phone_number'] ?? null;
    
    // دریافت با کیفیت‌ترین عکس
    $photo = $message['photo'] ?? null;
    if ($photo) {
        $file_id = end($photo)['file_id'];
    }
    
    // **💥 پردازش اعضای جدید (New Chat Members)**
    // این رویداد در یک پیام سیستمی به همراه 'message' می‌آید.
    if (!empty($message['new_chat_members'])) {
        $new_members = $message['new_chat_members'];
    }

} elseif (isset($update['callback_query'])) {
    $callback = $update['callback_query'];
    $chat_id = $callback['message']['chat']['id'];
    $from_id = $callback['from']['id'];
    $callback_data = $callback['data'];
    $callback_id = $callback['id'];
    $is_callback = true;
}

// اگر chat_id معتبر نبود، خروج
if (!$chat_id) exit;

/* -----------------------------------------------------
    بخش 3: 💸 منطق اعطای سکه برای Add Member (اولویت بالا)
    ----------------------------------------------------- */
if (count($new_members) > 0) {
    // 1. اطلاعات معرف (کسی که اعضا را اضافه کرده) را بخوانید
    $stmtRef = $conn->prepare("SELECT id, name FROM users WHERE chat_id = ?");
    $stmtRef->bind_param("i", $from_id);
    $stmtRef->execute();
    $referrer = $stmtRef->get_result()->fetch_assoc();
    $stmtRef->close();

    // فقط اگر معرف قبلاً در ربات ثبت نام کرده باشد، پاداش می‌گیرد.
    if ($referrer) {
        $new_reward_total = 0;
        $total_added = 0;
        $referrer_id = $referrer['id'];
        
        $conn->begin_transaction();
        
        foreach ($new_members as $member) {
            $member_chat_id = $member['id'];
            $botId = getBotId(); // دریافت شناسه ربات برای چک ضد تقلب
            
            // ❌ ضد تقلب 1: جلوگیری از پاداش برای اضافه کردن خود ربات
            if ($member_chat_id == $botId) continue; 
            
            // ❌ ضد تقلب 2: کاربر نباید خودش را اضافه کرده باشد
            if ($member_chat_id == $from_id) continue; 
            
            // ❌ ضد تقلب 3: چک کردن که آیا کاربر اضافه شده قبلاً در DB ثبت شده است یا خیر؟
            $stmtCheck = $conn->prepare("SELECT id FROM users WHERE chat_id = ?");
            $stmtCheck->bind_param("i", $member_chat_id);
            $stmtCheck->execute();
            if ($stmtCheck->get_result()->num_rows == 0) {
                
                // 2. اعطای سکه و افزایش شمارش معرف
                $stmtReward = $conn->prepare("UPDATE users SET coins = coins + ?, referral_count = referral_count + 1 WHERE id = ?");
                $stmtReward->bind_param("ii", $add_member_reward, $referrer_id);
                $stmtReward->execute();
                $stmtReward->close();
                
                $new_reward_total += $add_member_reward;
                $total_added++;
                
                // 3. ثبت نام اولیه کاربر اضافه شده در DB (برای جلوگیری از تقلب در آینده)
                $uuid = bin2hex(random_bytes(16));
                $member_username = $member['username'] ?? 'ندارد';
                $member_full_name = $member['first_name'] ?? 'ناشناس';

                $stmtInsertNew = $conn->prepare("INSERT INTO users (chat_id, username, name, referral_code, registration_step) VALUES (?, ?, ?, ?, 'name')");
                $stmtInsertNew->bind_param("isss", $member_chat_id, $member_username, $member_full_name, $uuid);
                $stmtInsertNew->execute();
                $stmtInsertNew->close();
            }
            $stmtCheck->close();
        }
        
        $conn->commit();
        
        // 4. اطلاع رسانی به معرف
        if ($new_reward_total > 0) {
            $referrer_name = htmlspecialchars($referrer['name'] ?? 'شما');
            sendMessage($from_id, "🎉 تبریک **{$referrer_name}**! شما **$total_added عضو جدید** اضافه کردید و **$new_reward_total سکه** جایزه گرفتید.");
        }
    }
    
    // چون این یک رویداد سیستمی Add Member است، از ادامه پردازش متنی جلوگیری می‌کنیم.
    exit; 
}

/* -----------------------------------------------------
    بخش 4: پردازش کالبک‌ها (دکمه‌های شیشه‌ای)
    ----------------------------------------------------- */
if ($is_callback) {
    
    // --- خواندن وضعیت کاربر برای انجام تراکنش ---
    $stmtUser = $conn->prepare("SELECT coins, name, referred_by FROM users WHERE chat_id=?");
    $stmtUser->bind_param("i", $from_id);
    $stmtUser->execute();
    $userRes = $stmtUser->get_result();
    $user = $userRes->fetch_assoc();
    $stmtUser->close();
    $userCoins = $user['coins'] ?? 0;

    // --- خرید محصول ---
    if (strpos($callback_data, "buyitem_") === 0) {
        $item_id = (int) str_replace("buyitem_", "", $callback_data);

        // 4.1. بهینه‌سازی: استفاده از Prepared Statement برای SELECT
        $stmt = $conn->prepare("SELECT id, name, price, data FROM products WHERE id=? AND quantity>0");
        $stmt->bind_param("i", $item_id);
        $stmt->execute();
        $stmt->bind_result($itemId, $itemName, $itemPrice, $itemData);
        $stmt->fetch();
        $stmt->close();

        if (!$itemId) {
            botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id, 'text' => "❌ محصول موجود نیست.", 'show_alert' => true]);
        } elseif ($userCoins < $itemPrice) {
            botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id, 'text' => "❌ موجودی کافی نیست. (موجودی: {$userCoins})", 'show_alert' => true]);
        } else {
            // 4.2. امنیت: انجام تراکنش با Prepared Statement
            $conn->begin_transaction();
            try {
                // کسر سکه
                $stmtCoin = $conn->prepare("UPDATE users SET coins = coins - ? WHERE chat_id=?");
                $stmtCoin->bind_param("ii", $itemPrice, $from_id);
                $stmtCoin->execute();
                $stmtCoin->close();

                // کسر موجودی محصول
                $stmtProd = $conn->prepare("UPDATE products SET quantity = quantity - 1 WHERE id=?");
                $stmtProd->bind_param("i", $item_id);
                $stmtProd->execute();
                $stmtProd->close();

                // ثبت سفارش
                $stmtOrder = $conn->prepare("INSERT INTO orders (chat_id, product_id, product_name, price, status) VALUES (?, ?, ?, ?, 'completed')");
                $stmtOrder->bind_param("iisi", $from_id, $itemId, $itemName, $itemPrice);
                $stmtOrder->execute();
                $stmtOrder->close();
                
                $conn->commit();
                
                // ارسال پیام موفقیت
                $detail_msg = "✅ خرید موفقیت‌آمیز بود!\n\n🛒 محصول: <b>" . htmlspecialchars($itemName) . "</b>\n💰 قیمت: <b>$itemPrice سکه</b>\n";
                if ($itemData) {
                    $detail_msg .= "\n🔑 دیتای محصول:\n<code>" . htmlspecialchars($itemData) . "</code>";
                }
                sendMessage($from_id, $detail_msg);
                
                botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id, 'text' => "✅ خرید انجام شد."]);

                // اطلاع رسانی پورسانت معرف (از سیستم لینک دعوت)
                if (!empty($user['referred_by'])) {
                    $stmtRef = $conn->prepare("SELECT chat_id FROM users WHERE referral_code=?");
                    $stmtRef->bind_param("s", $user['referred_by']);
                    $stmtRef->execute();
                    $refUserRes = $stmtRef->get_result();
                    $refUser = $refUserRes->fetch_assoc();
                    $stmtRef->close();
                    // اطلاع رسانی به معرف
                    if ($refUser) sendMessage($refUser['chat_id'], "🎉 زیرمجموعه شما ({$user['name']}) خریدی انجام داد.");
                }

            } catch (Exception $e) {
                $conn->rollback();
                botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id, 'text' => "❌ خطا در انجام تراکنش.", 'show_alert' => true]);
            }
        }
        exit;
    }

    // --- انتخاب تسک ---
    if (strpos($callback_data, "dotask_") === 0) {
        $task_id = (int) str_replace("dotask_", "", $callback_data);

        // دریافت جزئیات تسک
        $stmt = $conn->prepare("SELECT title, description, link FROM tasks WHERE id = ?");
        $stmt->bind_param("i", $task_id);
        $stmt->execute();
        $stmt->bind_result($tTitle, $tDesc, $tLink);
        
        if ($stmt->fetch()) {
            $stmt->close();
            
            // تغییر وضعیت کاربر
            $stateVal = "wait_proof_" . $task_id;
            $stmtUp = $conn->prepare("UPDATE users SET command_state = ? WHERE chat_id = ?");
            $stmtUp->bind_param("si", $stateVal, $from_id);
            $stmtUp->execute();
            $stmtUp->close();

            $msg = "📋 <b>" . htmlspecialchars($tTitle) . "</b>\n\n";
            $msg .= "توضیحات: " . htmlspecialchars($tDesc) . "\n";
            if ($tLink) $msg .= "لینک: " . htmlspecialchars($tLink) . "\n\n";
            $msg .= "📸 لطفاً <b>اسکرین‌شات</b> انجام کار یا توضیحات خود را همینجا ارسال کنید.\n(برای لغو گزینه '❌ انصراف' را بفرستید)";

            $kb = ['keyboard'=>[[['text'=>'❌ انصراف']]], 'resize_keyboard'=>true];
            sendMessage($from_id, $msg, $kb);
            
            botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id]);
        } else {
            $stmt->close();
            botRequest('answerCallbackQuery', ['callback_query_id' => $callback_id, 'text' => 'تسک یافت نشد.', 'show_alert' => true]);
        }
        exit;
    }
}

/* -----------------------------------------------------
    بخش 5: پردازش پیام‌های متنی و عکس
    ----------------------------------------------------- */
if ($message) {

    // 5.1. چک کردن وضعیت کاربر (اولویت بالا)
    $stmtState = $conn->prepare("SELECT id, command_state, registration_step, name, referral_count FROM users WHERE chat_id = ?");
    $stmtState->bind_param("i", $chat_id);
    $stmtState->execute();
    $stmtState->bind_result($uId, $uState, $uStep, $uFullName, $uReferralCount);
    $stmtState->fetch();
    $stmtState->close();
    
    // اگر کاربر دکمه انصراف را زده باشد
    if ($text === '❌ انصراف') {
        if ($uState) { 
            $conn->query("UPDATE users SET command_state = NULL WHERE chat_id = $chat_id");
            sendMessage($chat_id, "عملیات لغو شد.");
        }
        showMainPanel($chat_id);
        exit;
    }

    // 5.2. حالت ارسال مدرک (Proof Submission)
    if ($uState && strpos($uState, 'wait_proof_') === 0) {
        $task_id_extracted = (int) str_replace('wait_proof_', '', $uState);

        if ($file_id || $text) { 
            $proof_fid = $file_id ?: null;
            $proof_txt = $text ?: null;

            if (!$proof_fid && !$proof_txt) {
                sendMessage($chat_id, "لطفاً فقط عکس یا متن ارسال کنید.");
                exit;
            }

            // ثبت مدرک (استفاده از Prepared Statement)
            $stmtSub = $conn->prepare("INSERT INTO task_submissions (user_id, chat_id, task_id, proof_text, proof_file_id, status, created_at) VALUES (?, ?, ?, ?, ?, 'pending', NOW())");
            $stmtSub->bind_param("iiiss", $uId, $chat_id, $task_id_extracted, $proof_txt, $proof_fid);
            $stmtSub->execute();
            $stmtSub->close();

            // ریست کردن وضعیت
            $conn->query("UPDATE users SET command_state = NULL WHERE chat_id = $chat_id");

            sendMessage($chat_id, "✅ مدارک ارسال شد و منتظر تایید ادمین است.");
            showMainPanel($chat_id);
            exit;
        } else {
            sendMessage($chat_id, "لطفاً اسکرین‌شات یا توضیحات خود را ارسال کنید.");
            exit;
        }
    }

    // 5.3. ثبت نام کاربر (اگر وجود ندارد)
    if (!$uId) { 
        $referred_by = null;
        // چک کردن لینک دعوت
        if (strpos($text, "/start ref_") === 0) {
            $referred_by = substr($text, 11); 
        }
        $uuid = bin2hex(random_bytes(16));
        
        // ثبت نام (استفاده از Prepared Statement)
        $stmtInsert = $conn->prepare("INSERT INTO users (chat_id, username, referral_code, registration_step, referred_by) VALUES (?, ?, ?, 'name', ?)");
        $stmtInsert->bind_param("isss", $chat_id, $username, $uuid, $referred_by);
        $stmtInsert->execute();
        $stmtInsert->close();
        
        sendMessage($chat_id, "سلام 👋\nبه ربات خوش آمدید!\nلطفاً نام و نام خانوادگی خود را وارد کنید:");
        exit;
    }

    // 5.4. مراحل ثبت نام (بر اساس uStep)
    if ($uStep == 'name') {
        // ... (منطق ثبت نام 'name') ...
        if (mb_strlen($text) < 3) {
            sendMessage($chat_id, "⚠️ نام کوتاه است.");
            exit;
        }
        $stmtUp = $conn->prepare("UPDATE users SET name=?, registration_step='job' WHERE chat_id=?");
        $stmtUp->bind_param("si", $text, $chat_id);
        $stmtUp->execute();
        $stmtUp->close();
        
        sendMessage($chat_id, "✅ نام ثبت شد. شغل خود را وارد کنید:");
        exit;
    }

    if ($uStep == 'job') {
        // ... (منطق ثبت نام 'job') ...
        $stmtUp = $conn->prepare("UPDATE users SET job=?, registration_step='phone' WHERE chat_id=?");
        $stmtUp->bind_param("si", $text, $chat_id);
        $stmtUp->execute();
        $stmtUp->close();
        
        $kb = ['keyboard' => [[['text' => '📱 ارسال شماره تلفن', 'request_contact' => true]]], 'resize_keyboard' => true];
        sendMessage($chat_id, "شماره تلفن خود را ارسال کنید:", $kb);
        exit;
    }

    if ($uStep == 'phone') {
       if (!$contact) {
            // چک کردن دکمه بررسی عضویت در مرحله phone
            if ($text == "✅ بررسی عضویت در کانال") {
                if (isUserMemberOfChannel($chat_id, $channel_username)) {
                    $kb = ['keyboard' => [[['text' => '📱 ارسال شماره تلفن', 'request_contact' => true]]], 'resize_keyboard' => true];
                    sendMessage($chat_id, "✅ عضویت تایید شد. حالا شماره را با استفاده از دکمه زیر بفرستید.", $kb);
                } else {
                    sendMessage($chat_id, "❌ هنوز عضو نیستید.");
                }
                exit;
            }
            sendMessage($chat_id, "⚠️ لطفاً از دکمه زیر برای ارسال شماره تلفن استفاده کنید.");
            exit;
        }
        
        // چک عضویت کانال
        if (!isUserMemberOfChannel($chat_id, $channel_username)) {
            $kb = ['keyboard' => [[['text' => "✅ بررسی عضویت در کانال"]]], 'resize_keyboard' => true];
            sendMessage($chat_id, "لطفاً ابتدا عضو کانال شوید:\n$channel_username", $kb);
            exit;
        }

        // تکمیل ثبت نام
        $conn->begin_transaction();
        try {
            // به‌روزرسانی اطلاعات کاربر و اهدای سکه ثبت نام
            $stmtUp = $conn->prepare("UPDATE users SET phone=?, registration_step=NULL, coins=coins+? WHERE chat_id=?");
            $stmtUp->bind_param("sii", $contact, $registration_reward, $chat_id);
            $stmtUp->execute();
            $stmtUp->close();
            
            // دریافت کد معرف کاربر برای پورسانت
            $referred_by_code = $conn->query("SELECT referred_by FROM users WHERE chat_id='$chat_id'")->fetch_assoc()['referred_by'] ?? null;
            
            // پورسانت ثبت نام به معرف (فقط از لینک دعوت)
            if (!empty($referred_by_code)) {
                $stmtRef = $conn->prepare("UPDATE users SET coins = coins + ? WHERE referral_code=?");
                $stmtRef->bind_param("is", $referral_completion_reward, $referred_by_code);
                $stmtRef->execute();
                $stmtRef->close();
                // بهتر است به معرف هم پیام داده شود، اما برای سادگی در اینجا حذف شد.
            }
            $conn->commit();

            sendMessage($chat_id, "🎉 ثبت نام تکمیل شد. **$registration_reward سکه** دریافت کردید.");
            showMainPanel($chat_id);

        } catch (Exception $e) {
            $conn->rollback();
            sendMessage($chat_id, "❌ خطایی در ذخیره سازی اطلاعات رخ داد.");
        }
        exit;
    }

    // 5.5. دستورات منوی اصلی
    
    // دکمه بررسی عضویت در منوی اصلی (خارج از مرحله ثبت نام)
    if ($text == "✅ بررسی عضویت در کانال") {
        if (isUserMemberOfChannel($chat_id, $channel_username)) {
            sendMessage($chat_id, "✅ شما عضو کانال هستید.");
        } else {
            sendMessage($chat_id, "❌ هنوز عضو کانال نیستید: $channel_username");
        }
        exit;
    }
    
    // دکمه نمایش آمار Add Member
    if ($text == "🔗 آمار اعضا") {
        $msg = "🤝 **آمار اعضای معرفی شده (Add Member)**\n\n";
        $msg .= "شما با اضافه کردن هر عضو جدید و ناشناس به گروه، **$add_member_reward سکه** جایزه می‌گیرید.\n\n";
        $msg .= "👤 **تعداد کل اعضایی که شما اضافه کرده‌اید:** **{$uReferralCount} نفر**"; // استفاده از $uReferralCount خوانده شده در بالا

        sendMessage($chat_id, $msg);
        exit;
    }

    if ($text == "/start" || $text == "🎛 پنل کاربری") {
        showMainPanel($chat_id);
        exit;
    }

    if ($text == "💰 مشاهده سکه‌ها") {
        $stmtCoin = $conn->prepare("SELECT coins FROM users WHERE chat_id=?");
        $stmtCoin->bind_param("i", $chat_id);
        $stmtCoin->execute();
        $userCoins = $stmtCoin->get_result()->fetch_assoc()['coins'] ?? 0;
        $stmtCoin->close();

        sendMessage($chat_id, "💰 سکه‌های شما: $userCoins");
        exit;
    }

    if ($text == "🛒 فروشگاه" || $text == "/shop") {
        // ... (منطق فروشگاه) ...
        $res = $conn->query("SELECT id, name, price FROM products WHERE quantity > 0 LIMIT 5");
        
        if ($res->num_rows == 0) {
            sendMessage($chat_id, "فعلاً محصولی برای خرید موجود نیست.");
        } else {
            $kb = ['inline_keyboard' => []];
            while ($row = $res->fetch_assoc()) {
                $kb['inline_keyboard'][] = [[
                    'text' => htmlspecialchars($row['name']) . " (" . $row['price'] . " سکه)",
                    'callback_data' => "buyitem_" . $row['id']
                ]];
            }
            sendMessage($chat_id, "یک محصول انتخاب کنید:", $kb);
        }
        exit;
    }

    if ($text === '📋 انجام تسک و درآمد') {
        // ... (منطق نمایش تسک‌ها) ...
        $stmt = $conn->prepare("SELECT id, title, reward FROM tasks WHERE is_active = 1");
        $stmt->execute();
        $stmt->bind_result($tid, $ttitle, $treward);
        
        $found = false;
        while ($stmt->fetch()) {
            $found = true;
            $kb = ['inline_keyboard' => [[['text' => "انجام ($treward سکه)", 'callback_data' => "dotask_$tid"]]]];
            sendMessage($chat_id, "📝 <b>" . htmlspecialchars($ttitle) . "</b>\n🎁 پاداش: $treward سکه", $kb);
        }
        $stmt->close();
        
        if (!$found) sendMessage($chat_id, "فعلاً تسکی برای انجام دادن نیست.");
        exit;
    }
    
    // پیام پیش فرض برای دستورات نامعتبر
    if (!$uStep) {
        showMainPanel($chat_id);
    }
}